# Contributing to Pointshop

Looking to contribute something to Pointshop? **Here's how you can help.**

## Reporting issues

We only accept issues that are bug reports or feature requests. Bugs must be isolated and reproducible problems that we can fix within the Pointshop core. Please read the following guidelines before opening any issue.

1. **Search for existing issues.** We get a lot of duplicate issues, and you'd help us out a lot by first checking if someone else has reported the same issue. Moreover, the issue may have already been resolved with a fix available.
2. **Create an isolated and reproducible test case.** Be sure the problem exists in Pointshop's code.
3. **Share as much information as possible.** Include operating system and version, version of Pointshop, customized or vanilla build, etc. where appropriate. Also include steps to reproduce the bug.

## Pull requests

- Test your changes before hand, make sure they work with a clean Pointshop installation.
- Try not to pollute your pull request with unintended changes--keep them simple and small

## Coding standards

- No semicolons
- Four spaces for indentation, never tabs.
- Use descriptive variable naming, lowerCamelCase for locals, UpperCamelCase for public.
- Don't pollute _G or PS tables.
- "Attractive"

## License

By contributing your code, you agree to license your contribution under the terms of the MIT: https://github.com/adamdburton/pointshop/blob/master/LICENSE